# INFO:
#   Script to visualise EN1926 drop data.
#   Quickstart example that shows loading a CSV and plotting accel vs time0.
#
# Requirements:
#   pip install pandas matplotlib
#
# This script loads a CSV file (drop_0.csv), skips the first 10 rows,
# and plots accel vs time0 using matplotlib.
#
# Nov 2025 - Fred

# %%
import pandas as pd
import matplotlib.pyplot as plt

# 1) Load the CSV file
# Replace the path below with the other files if you want
csv_path = "drop_0.csv"
df = pd.read_csv(csv_path, skiprows=10)

# %% inspect the first rows and column names
print(df.head())
print(df.columns)

# %% Plot accel vs time0
plt.figure()
plt.plot(
    df["time0"], df["accel"]
)  # make sure these names match your actual column names
plt.xlabel("time0")
plt.ylabel("accel")
plt.title("accel vs time0")
plt.grid(True)
plt.tight_layout()
plt.show()
# %%
print("That's all folks :-)")
